package kom.itbeankit.nw.ethernet;

import java.awt.*;


import kom.itbeankit.nw.ethernet.BusElement;
import symantec.itools.awt.shape.HorizontalLine;
import symantec.itools.awt.shape.VerticalLine;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.vcr.ClkEvent;

import kom.itbeankit.nw.ethernet.HubElement;
public class Hub extends java.awt.Container implements EthernetInterface,ClkListener
{
	public Hub()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(130,76);
		panel = new java.awt.Panel();
		panel.setLayout(null);
		panel.setBounds(0,0,130,76);
		add("Center", panel);
		busElement1 = new kom.itbeankit.nw.ethernet.BusElement();
		busElement1.setLayout(new BorderLayout(0,0));
		busElement1.setBounds(0,30,15,15);
		panel.add(busElement1);
		busElement2 = new kom.itbeankit.nw.ethernet.BusElement();
		busElement2.setLayout(new BorderLayout(0,0));
		busElement2.setBounds(58,0,15,15);
		panel.add(busElement2);
		busElement4 = new kom.itbeankit.nw.ethernet.BusElement();
		busElement4.setLayout(new BorderLayout(0,0));
		busElement4.setBounds(115,30,15,15);
		panel.add(busElement4);
		hubElement1 = new kom.itbeankit.nw.ethernet.HubElement();
		hubElement1.setLayout(new BorderLayout(0,0));
		hubElement1.setBounds(15,15,100,46);
		panel.add(hubElement1);
		busElement3 = new kom.itbeankit.nw.ethernet.BusElement();
		busElement3.setLayout(new BorderLayout(0,0));
		busElement3.setBounds(58,61,15,15);
		panel.add(busElement3);
		//}}
		//setSize(85,30);

		//{{REGISTER_LISTENERS
		SymData lSymData = new SymData();

		busElement1.addDataListener(lSymData);
		busElement2.addDataListener(lSymData);
		busElement3.addDataListener(lSymData);
		busElement4.addDataListener(lSymData);

		hubElement1.addDataListener(lSymData);
		//}}
	}
	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	kom.itbeankit.nw.ethernet.BusElement busElement1;
	kom.itbeankit.nw.ethernet.BusElement busElement2;
	kom.itbeankit.nw.ethernet.BusElement busElement4;
	kom.itbeankit.nw.ethernet.HubElement hubElement1;
	kom.itbeankit.nw.ethernet.BusElement busElement3;
	//}}
    private java.util.Vector dataListeners = new java.util.Vector();
    /*public Dimension getPreferredSize(){
        return new Dimension(80,30);
    }*/

    /*public void paint(Graphics g){
        super.paint(g);
        //setSize(getPreferredSize());
        panel.setSize(getSize());

    }*/


    public synchronized void addDataListener(DataListener lis)
    {
        dataListeners.addElement(lis);
    }

    public synchronized void removeDataListener(DataListener lis)
    {
        dataListeners.removeElement(lis);
    }

    public void dataFromRight(DataEvent e)
    {
        busElement4.dataFromRight(e);
    }

    public void dataFromLeft(DataEvent e)
    {
        busElement1.dataFromLeft(e);
    }

    public void dataFromTop(DataEvent e)
    {
        busElement2.dataFromTop(e);
    }

    public void dataFromBottom(DataEvent e)
    {
        busElement3.dataFromBottom(e);
    }


    public void clkReceived(ClkEvent e){
		hubElement1.clkReceived(e);
		busElement1.clkReceived(e);
		busElement2.clkReceived(e);
		busElement3.clkReceived(e);
		busElement4.clkReceived(e);

    }

    public void reset(){
		hubElement1.reset();
		busElement1.reset();
		busElement2.reset();
		busElement3.reset();
		busElement4.reset();

    }

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(100,60);
				this.add(new Hub());
			}
		}

		new DriverFrame().show();
	}

  public void setHubLabel(String st){
        this.hubLabel = st;
        hubElement1.setTheLabel(st);
    }

    public String getHubLabel(){
        return hubLabel;
    }


	void busElement1_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToLeft(new DataEvent(this,event));
        }
	}

	void busElement4_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.
		//event to right should be created
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToRight(new DataEvent(this,event));
        }
	}

	void busElement2_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToTop(new DataEvent(this,event));
        }
	}

	void busElement3_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToBottom(new DataEvent(this,event));
        }
	}

	class SymData implements kom.itbeankit.nw.ethernet.DataListener
	{
		public void dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busElement1)
				busElement1_dataToRight(event);
			else if (object == hubElement1)
				hubElement1_dataToRight(event);
			else if (object == busElement4)
			    busElement4_dataToRight(event);
		}

		public void dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busElement3)
				busElement3_dataToTop(event);
			else if (object == hubElement1)
				hubElement1_dataToTop(event);
			else if (object == busElement2)
			    busElement2_dataToTop(event);
		}

		public void dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busElement2)
				busElement2_dataToBottom(event);
			else if (object == hubElement1)
				hubElement1_dataToBottom(event);
			else if (object == busElement3)
			    busElement3_dataToBottom(event);

		}

		public void dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busElement4)
				busElement4_dataToLeft(event);
			else if (object == hubElement1)
				hubElement1_dataToLeft(event);
			else if (object == busElement1)
			    busElement1_dataToLeft(event);
		}
	}

	void busElement1_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			hubElement1.dataFromLeft(event);
		}
		//}}
	}

	void busElement2_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			hubElement1.dataFromTop(event);
		}
		//}}
	}

	void busElement4_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			hubElement1.dataFromRight(event);
		}
		//}}
	}

	void busElement3_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			hubElement1.dataFromBottom(event);
		}
		//}}
	}

	void hubElement1_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			busElement1.dataFromRight(event);
		}
		//}}
	}

	void hubElement1_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			busElement2.dataFromBottom(event);
		}
		//}}
	}

	void hubElement1_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			busElement4.dataFromLeft(event);
		}
		//}}
	}

	void hubElement1_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			busElement3.dataFromTop(event);
		}
		//}}
	}
	private String hubLabel = new String ("HUBi");
}